<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Hisa;
use App\Models\Akiba;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class UserController extends Controller
{
    //
    public function allUsers() {

        $all_info = User::query()
        ->leftJoin('hisas', function ($join) {
            $join->on('users.id', '=', 'hisas.member_id')
                 ->where('hisas.status', '=', 1);
        })
        ->leftJoin('akibas', function ($join) {
            $join->on('users.id', '=', 'akibas.member_id')
                 ->where('akibas.status', '=', 1);
        })
        ->select(
            'users.id',
            'users.name',
            'users.sname',
            'users.lname',
            'users.membership_no',
            'users.mobile_no',
            'users.address',
            DB::raw('COALESCE(SUM(hisas.amount), 0) as hisa_amount'),
            DB::raw('COALESCE(SUM(akibas.amount), 0) as akiba_amount')
        )
        ->groupBy('users.id', 'users.name', 'users.sname', 'users.lname')
        ->get();

        return view('admin/users/users_all', compact('all_info'));
    }


    public function addUser() {
        return view('admin/users/users_add');
    }

    public function userStore(Request $request) {

        $validateData = $request->validate([
            'name' => 'required',
            'sname' => 'required',
            'lname' => 'required',
            'mobile_no' => 'required|regex:/0[6-9][0-9]{8}/',
            'email' => 'required',
            'address' => 'required',
            'membership_no' => 'required',
        ]);


        User::insert([
            'name' => $request->name,
            'sname' => $request->sname,
            'lname' => $request->lname,
            'email' => $request->email,
            'mobile_no' => $request->mobile_no,
            'address' => $request->address,
            'membership_no' => $request->membership_no,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);
        $notification = array(
            'message' => 'User added successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('users.all')->with($notification);
    } // End of method

     public function userEdit($id) {

        $userData = User::findOrFail($id);
        return view('admin/users/users_edit',compact('userData'));
    }
    // End of method

    public function userUpdate(Request $request) {

        $user_id = $request->id;
        $userData = User::findOrFail($user_id)->update([
            'name' => $request->name,
            'sname' => $request->sname,
            'lname' => $request->lname,
            'email' => $request->email,
            'mobile_no' => $request->mobile_no,
            'address' => $request->address,
            'membership_no' => $request->membership_no,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'User information updated successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('users.all')->with($notification);
    }
     // End of method

    public function userDelete($id) {

        User::findOrFail($id)->delete();

        $notification = array(
            'message' => 'User deleted successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('users.all')->with($notification);
    }
    // End of method

    public function userHisa($id) {

        $userData = User::findOrFail($id);
        $total_hisa = Hisa::where('member_id', $userData->id)->where('status',1)->get();
        $all_users = User::where('id', $userData->id)->get();

        $total_akiba = Akiba::where('member_id', $userData->id)->where('status',1)->get();

        return view('admin/users/users_view_hisa',compact('userData','all_users','total_hisa','total_akiba'));
        return view('admin/users/users_view_akiba',compact('userData','all_users','total_hisa','total_akiba'));
    }
    // End of method

    public function userAkiba($id) {

        $userData = User::findOrFail($id);
        $total_hisa = Hisa::where('member_id', $userData->id)->where('status',1)->get();
        $all_users = User::where('id', $userData->id)->get();

        $total_akiba = Akiba::where('member_id', $userData->id)->where('status',1)->get();

        return view('admin/users/users_view_akiba',compact('userData','all_users','total_hisa','total_akiba'));
    }
    // End of method

    

}
